﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Win32;
using Winfoot_7_SDK;

namespace WinfootDefaultSystemPlugin.Controls.Strategy
{
    public interface ISafeDllSearchModeStrategy
    {
        void Write(int i);
        WFRegistry Read();
        List<WFRegistry> BackUp();
    }

    public class SafeDllSearchModeDefaultStrategy : ICorrespondenceOS, ISafeDllSearchModeStrategy
    {
        public SafeDllSearchModeDefaultStrategy()
        {
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
#if DEBUG
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           OS.WindowsVista_SP2,
                                           OS.WindowsSeven
#endif
                                       };
        }

        private string RegName = "SafeDllSearchMode";

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        #region IAdditionalWorkerThreadsStrategy メンバ

        public void Write(int i)
        {
            RegistryKey registryKey =
                Registry.LocalMachine.CreateSubKey(
                    @"SYSTEM\CurrentControlSet\Control\Session Manager");

            registryKey.SetValue(RegName, i);
        }

        public WFRegistry Read()
        {
            RegistryKey registryKey =
                Registry.LocalMachine.OpenSubKey(
                    @"SYSTEM\CurrentControlSet\Control\Session Manager");

            return new WFRegistry(@"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager", RegName,
                              registryKey.GetValue(RegName, 0), RegistryValueKind.DWord, RegOperation.KeyWrite);



        }

        public List<WFRegistry> BackUp()
        {
            return new List<WFRegistry> { Read() };
        }

        #endregion
    }

    public class SafeDllSearchModeController
    {
        public SafeDllSearchModeController(SafeDllSearchMode safeDllSearchMode,
                                                         ISafeDllSearchModeStrategy strategy)
        {
            SafeDllSearchMode = safeDllSearchMode;
            Strategy = strategy;
        }

        public SafeDllSearchMode SafeDllSearchMode { get; set; }
        public ISafeDllSearchModeStrategy Strategy { get; set; }

        public void Read()
        {
            SafeDllSearchMode.SetSafeDllSearchModeState(Convert.ToBoolean(Strategy.Read().Value));
        }

        public void Write()
        {
            Strategy.Write(SafeDllSearchMode.GetSafeDllSearchModeState());
        }

        public List<WFRegistry> BackUp()
        {
            return Strategy.BackUp();
        }
    }
}
